<?php


class AopsContentUpgradeTabs extends Aops {


	public $pluginRoot = '';
	public $options = array();
	public $cu_id = 0;

	private $popupFieldGroups;
	private $miscFieldGroups;
	private $emailFieldGroups;

	static $checkedFields = array(
		'mailchimp_extra_list_id' => 'mailchimp_extra_list_status'
	);

	public function __construct($pluginRoot) {

		$this->pluginRoot = $pluginRoot;
		$this->options = $this->getOptions();

		/* Create 'Content upgrades' metabox */
		add_action( 'add_meta_boxes', array( $this, 'createCuMetabox' ) );

		/* Save 'Content upgrades'  metabox */
		add_action( 'save_post', array( $this, 'saveMetabox' ) );

		/* Create "Insert CU" button to TinyMCE on Edit Post screen  */
		add_action( 'admin_head', array( $this, 'createTinyMCEInsertCuButton') );
		add_filter('mce_external_plugins', array( $this, 'addTinymceInsertCUPlugin'));

		/* add "Insert CU" window on Edit Post screen  */
		add_action('edit_form_after_editor', array( $this, 'createInsertCuButton') );

	}

	public function createCuMetabox() {
		add_meta_box(
			'aops_content_upgrades',					// id
			__( 'Content Upgrade Options', 'aops' ),	// title
			array( $this, 'displayMetabox' ),			// callback
			self::$postTypeName,						// page
			'normal',									// context
			'default'									// priority
		);
	}

	// inlcude the js for tinymce
	public function addTinymceInsertCUPlugin($plugin_array) {
		//$plugin_array['aops_insert_cu'] = plugins_url( '../js/aops-admin.js', __FILE__ );
		$plugin_array['aops_insert_cu'] = plugins_url( '../js/aops-admin-tinymce.js', __FILE__ );
		return $plugin_array;
	}

	/**
	 * Creates "Insert CU" button to TinyMCE on Edit Post screen
	 */
	public function createTinyMCEInsertCuButton() {
		global $typenow;

		// only on Post Type: post and page
		if( ! in_array( $typenow, array( 'post', 'page', 'aops_landing_page' ) ) )
			return ;

		add_filter( 'mce_buttons', array( $this, 'addTinymceInsertCuButton' ));
	}

	// Add the button key for address via JS
	public function addTinymceInsertCuButton( $buttons ) {
		array_push( $buttons, 'aops_insert_cu_button_key' );
		return $buttons;
	}

	/**
	 * Creates "Insert CU" button on Edit Post screen
	 */
	public function createInsertCuButton() {
		global $typenow;

		// only on Post Type: post and page
		if( ! in_array( $typenow, array( 'post', 'page', 'aops_landing_page') ) ) {
			return;
		}

		$html = '<div id="aops-content-upgrades-list" style="display:none">';
		$html .= '<h2>Select Content upgrade to insert</h2>';
		$html .= $this->makeUpgradesListForm();
		$html .= '</div>';
		// notify about copy
		$html .= '<div id="flash-message"></div>';

		echo $html;
	}

	/**
	 * Save 'Content upgrades'  metabox
	 *
	 * @param int $post_id The post ID
	 */
	public function saveMetabox( $post_id ) {

		if ( !isset( $_POST[self::$metaPrefix] ) || !isset( $_POST['aops_meta_box_nonce'] ) || !wp_verify_nonce( $_POST['aops_meta_box_nonce'], basename( $this->pluginRoot ) ) )
			return $post_id;

		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
			return $post_id;

		if ( self::$postTypeName == $_POST['post_type'] ) {
			if ( !current_user_can( 'edit_page', $post_id ) ) return $post_id;
		} else {
			if ( !current_user_can( 'edit_post', $post_id ) ) return $post_id;
		}

		//echo( '$_POST[self::$metaPrefix]<pre>' . print_r($_POST[self::$metaPrefix], 1) . '</pre>' );die();
		// save data
		foreach( $_POST[self::$metaPrefix] as $key => $val ) {
			$meta_name = self::$metaPrefix . '_' . $key;
			delete_post_meta( $post_id, $meta_name);
			add_post_meta( $post_id, $meta_name, $val, true );
		}

		// save checkboxes state (they don`t show in POST array if not checked)
		foreach (self::$checkboxes as $checkboxName) {
			if ( ! isset($_POST[self::$metaPrefix][$checkboxName] ) ) {
				$meta_name = self::$metaPrefix . '_' . $checkboxName;
				delete_post_meta( $post_id, $meta_name);
				add_post_meta( $post_id, $meta_name, 0, true );
			}
		}

		// save multiple selects (they don`t show in POST array if no options selected)
		foreach (self::$multiples as $multipleSelect) {
			if ( ! isset( $_POST[self::$metaPrefix][$multipleSelect] ) ) {
				$meta_name = self::$metaPrefix . '_' . $multipleSelect;
				delete_post_meta( $post_id, $meta_name);
				add_post_meta( $post_id, $meta_name, array(), true );
			}
		}

		// save status for checked fields
		foreach (self::$checkedFields as $checkedFieldName => $checkingStatusField) {
			if (isset($_POST[self::$metaPrefix][$checkedFieldName])) {
				$val = $_POST[self::$metaPrefix][$checkedFieldName];
				$meta_name = self::$metaPrefix . '_' . $checkingStatusField;

				$status = $this->getCheckedFieldStatus($checkedFieldName, $val);
				delete_post_meta( $post_id, $meta_name);
				add_post_meta( $post_id, $meta_name, $status, true );
			}
		}

	}

	private function getCheckedFieldStatus($checkedFieldName, $fieldValue) {
		switch ($checkedFieldName) {
			case 'mailchimp_extra_list_id':
				if ($fieldValue) {
					$response = AopsMailchimpIntegration::checkIfMailchimpListExists($fieldValue);
					if ($response) {
						$result = self::STATUS_OK;
					}
					else {
						$result = self::STATUS_FAIL;
					}
				}
				else {
					$result = self::STATUS_UNKNOWN;
				}
				break;
			default:
				$result = self::STATUS_UNKNOWN;
		}

		return $result;
	}

	private function preparePopupFieldGroups() {
		return array(
			'Popup content' => array(
				array(
					'id'			=> 'headline',
					'name'			=> self::$metaPrefix . '[headline]',
					'type'			=> 'text',
					'size'			=> 45,
					'label'			=> 'Headline',
					'description'	=> 'Headline to display in the popup.<br>Leave blank to disable headline'
				),
				array(
				   'id'				=> 'description',
				   'name'			=> self::$metaPrefix .'[description]',
				   'type'			=> 'textarea',
				   'rows'			=> 3,
				   'cols'			=> 45,
				   'label'			=> 'Description',
				   'description'	=> 'Description to display in the popup.<br>Leave blank to disable description'
				)
			),
			'Form' => array(
				array(
					'id'			=> 'button_text',
					'name'			=> self::$metaPrefix .'[button_text]',
					'type'			=> 'text',
					'size'			=> 45,
					'label'			=> 'Button text',
					'description'	=> 'Button text for the opt-in form.<br>Defaults to: <em>' . $this->options['button_default_text'] . '</em>'
				)
			),
			'Preload' => array(
				array(
					'id'			=> 'preload_page_ids',
					'name'			=> self::$metaPrefix .'[preload_page_ids]',
					'type'			=> 'text',
					'size'			=> 45,
					'label'			=> 'Preload on these pages and posts',
					'description'	=> 'Optional. Enter the page or post IDs you want this content upgrade popup to be pre-loaded on. '
									. '<br>Useful if you\'re manually triggering the popup in a link instead of using the shortcode.'
				)
			),
			'Behavior' => array(
				array(
					'id'			=> 'download_enabled',
					'name'			=> self::$metaPrefix .'[download_enabled]',
					'type'			=> 'checkbox_with_tooltip',
					'label'			=> 'Display bonus content download link immediately',
					'description'	=> 'When checked, the download link for this content upgrade, along with the message below will be displayed inside the popup immediately after the form is submitted. '
										 . '<br>When unchecked, the user will only see a "Thank You" message and will only receive the download link via email.',
					'default'		=> 1
				),
				array(
					'id'			=> 'download_text',
					'name'			=> self::$metaPrefix .'[download_text]',
					'type'			=> 'rich_textarea',
					'height'		=> 200,
					'label'			=> 'Text in download popup',
					'description'	=> 'Display this text in the popup immediately after the form is submitted. To insert a link pointing to the bonus download, use this code: {bonus_content_title_link}',
					'default'		=> $this->options['download_text'],
					'display'		=> $this->meta['download_enabled']
				),
				array(
					'id'			=> 'share_buttons_enabled',
					'name'			=> self::$metaPrefix .'[share_buttons_enabled]',
					'type'			=> 'checkbox',
					'label'			=> 'Enable social sharing buttons on the download bonus content popup',
					'default'		=> $this->options['share_buttons_enabled'],
					'display'		=> $this->meta['download_enabled']
				),
				array(
					'id'			=> 'share_buttons_header_text',
					'name'			=> self::$metaPrefix .'[share_buttons_header_text]',
					'type'			=> 'text',
					'size'			=> 20,
					'label'			=> 'Sharing Label',
					'description'	=> 'Edit the text shown above the social sharing buttons.',
					'default'		=> $this->options['share_buttons_header_text'],
					'display'		=> $this->meta['download_enabled']
				),
				array(
					'id'			=> 'redirect_after_formfill_enabled',
					'name'			=> self::$metaPrefix .'[redirect_after_formfill_enabled]',
					'type'			=> 'checkbox_with_tooltip',
					'label'			=> 'Redirect user to a different page after they fill out this CU form',
					'description'	=> 'Leave this unchecked if you want the user to remain on the current page after they\'ve filled out the CU form. '
									. 'You can also display the CU download button right inside the popup without making the user leave the page.',
					'default'		=> false
				),
				array(
					'id'			=> 'redirect_after_formfill_url',
					'name'			=> self::$metaPrefix .'[redirect_after_formfill_url]',
					'type'			=> 'text',
					'size'			=> 20,
					'label'			=> 'Redirect page URL',
					'display'		=> $this->meta['redirect_after_formfill_enabled']
				),
				array(
					'id'			=> 'exit_popup_enabled',
					'name'			=> self::$metaPrefix .'[exit_popup_enabled]',
					'type'			=> 'checkbox_with_tooltip',
					'label'			=> 'Enable Exit-Intent Popup',
					'description'	=> 'When checked, this content upgrade will have the exit-intent popup enabled. '
									.'This will pop up the Content Upgrade offer when the user\'s mouse exits the page viewport',
					'default'		=> $this->options['exit_popup_enabled']
				)
		   )
	   );
	}

	private function prepareMiscFieldGroups($post) {
		return array(
			'Facebook conversion event' => array(
				array(
					'id'			=> 'facebook_conversion_event_enabled',
					'name'			=> self::$metaPrefix . '[facebook_conversion_event_enabled]',
					'type'			=> 'checkbox_with_tooltip',
					'label'			=> 'Fire a Facebook conversion event whenever this content upgrade form has been submitted',
					'description'	=> 'If you\'re using Facebook Ads, and you already have the Facebook Pixel installed on your site, then check this box if you want to fire an event to register a conversion in Facebook anytime someone completes <b>this</b> content upgrade form.<br><br>Note: You must have the Facebook pixel installed on your site (and page where your content upgrades display).<br><br>Also note: You can add a global Facebook event anytime any content upgrade is submitted by setting that up in Content Upgrades &gt; Settings &gt; General Settings.'
				),
				array(
					'id'			=> 'facebook_conversion_event_name',
					'name'			=> self::$metaPrefix . '[facebook_conversion_event_name]',
					'type'			=> 'text',
					'size'			=> 45,
					'label'			=> 'Facebook conversion event name',
					'default'		=> '[Content Upgrade Opt-in] {content_upgrade_title}',
					'description'	=> 'Give this Facebook conversion event a name, which will register in the Facebook Ads interface. It should be specific to this content upgrade.',
					'display'		=> $this->meta['facebook_conversion_event_enabled']
				)
			),
			'Google Analytics event' => array(
				array(
					'id'			=> 'google_analytics_submit_event_enabled',
					'name'			=> self::$metaPrefix . '[google_analytics_submit_event_enabled]',
					'type'			=> 'checkbox_with_tooltip',
					'label'			=> 'Fire a Google Analytics event whenever this content upgrade form has been submitted',
					'description'	=> 'When this option is enabled and a user submits a content upgrade form, a Google Analytics event '
						. 'called \'Content Upgrade\' will be sent to your Google Analytics account. '
						. 'Its description will match the title of the specific Content Upgrade. '
						. 'You must ensure your Google Analytics universal tracking code is installed on your site.',
					'default'		=> $this->options['google_analytics_submit_event_enabled']
				)
			),
			'Custom conversion event' => array(
				array(
					'id'			=> 'custom_conversion_event_enabled',
					'name'			=> self::$metaPrefix . '[custom_conversion_event_enabled]',
					'type'			=> 'checkbox_with_tooltip',
					'label'			=> 'Trigger a custom JavaScript event whenever this content upgrade form has been submitted',
					'description'	=> 'This applies only to this CU. If you want to fire a JS event for all CUs, '
						. 'you can do so in Content Upgrades Settings.'
				),
				array(
					'id'			=> 'custom_conversion_event_code',
					'name'			=> self::$metaPrefix . '[custom_conversion_event_code]',
					'type'			=> 'textarea',
					'rows'			=> 4,
					'cols'			=> 45,
					'label'			=> 'Custom JS code',
					'description'	=> htmlspecialchars('Do not include <script> </script> tags'),
					'default'		=> "ga('send', 'event', 'Content Upgrade', 'Click', 'Custom Event Description' , {'NonInteraction': 1});",
					'display'		=> $this->meta['custom_conversion_event_enabled']
				)
			)
	   );
	}

	private function prepareEmailFieldGroups() {
		return array(
		   'Email to user' => array(
			    array(
				   'id'				=> 'user_email_enabled',
				   'name'			=> self::$metaPrefix . '[user_email_enabled]',
				   'type'			=> 'checkbox_with_tooltip',
				   'label'			=> 'Enable email to user',
				   'description'	=> 'When checked, this email (typically containing the download link, but you can edit it below)'
										. ' will be immediately sent to the user upon filling out a Content Upgrade form.'
										. ' Uncheck this box to disable this immediate email.'
										. ' <br>If not sending this email to the user, you may want to enable displaying the download link'
										. ' inside the popup immediately after the form is filled out, which you can enable in the Popup settings.',
					'default'		=> $this->options['user_email_enabled']
			   ),
			   array(
				   'id'				=> 'user_email_subject',
				   'name'			=> self::$metaPrefix . '[user_email_subject]',
				   'type'			=> 'text',
				   'size'			=> 45,
				   'label'			=> 'Subject',
				   'default'		=> $this->options['default_email_subject'],
				   'description'	=> 'Subject line of the email sent to user'
			   ),
			   array(
				   'id'				=> 'user_email_body',
				   'name'			=> self::$metaPrefix .'[user_email_body]',
				   'type'			=> 'rich_textarea',
				   'height'			=> 200,
				   'label'			=> 'Body',
				   'description'	=> 'Body of the email sent to user.<br><br>Available substitutions: {user_first_name}, {user_email}, {date_of_entry}, {content_upgrade_title}, {bonus_content_title_link}, {bonus_content_file}',
				   'default'		=> $this->options['default_email_body']
			   )
		   ),
		   'Email to administrator' => array(
				array(
					'id'			=> 'admin_email_enabled',
					'name'			=> self::$metaPrefix . '[admin_email_enabled]',
					'type'			=> 'checkbox',
					'label'			=> 'Enable email to administrator',
					'default'		=> $this->options['default_admin_email_enabled'],
					'description'	=> 'Check this box to disable notifications for this Content Upgrade. Note: You can override this and disable notifications for ALL Content Upgrades in Content Upgrade Settings'
				),
				array(
					'id'			=> 'admin_email_address',
					'name'			=> self::$metaPrefix . '[admin_email_address]',
					'type'			=> 'text',
					'size'			=> 45,
					'label'			=> 'Email to',
					'description'	=> 'Email address(s) where you wish to receive notifications for this content upgrade. '
										 .' Defaults to the WordPress Admin.  You can set the administrator email for all Content Upgrades in the Content Upgrades Settings'
				),
				array(
					'id'			=> 'admin_email_subject',
					'name'			=> self::$metaPrefix . '[admin_email_subject]',
					'type'			=> 'text',
					'size'			=> 45,
					'label'			=> 'Subject',
					'default'		=> $this->options['default_admin_email_subject'],
					'description'	=> 'Subject line of the email sent to administrator'
				),
				array(
					'id'			=> 'admin_email_body',
					'name'			=> self::$metaPrefix .'[admin_email_body]',
					'type'			=> 'rich_textarea',
					'height'		=> 200,
					'label'			=> 'Body',
					'description'	=> 'Body of the email sent to administrator. <br><br>Available substitutions: {user_first_name}, {user_email}, {date_of_entry}, {content_upgrade_title}',
					'default'		=> $this->options['default_admin_email_body'],
				)
		   )
	   );
	}

	private function prepareInsertFieldGroups($post) {

		return array(
		   'How to insert' => array(
			   array(
				   'id'				=> 'shortcode_template',
				   'name'			=> self::$metaPrefix . '[shortcode_template]',
				   'type'			=> 'copy_textarea',
				   'label'			=> 'Call-to-Action Box',
				   'default'		=> htmlspecialchars('[content_upgrade cu_id="' . $post->ID . '"]Get the bonus content: ') . $post->post_title . '[content_upgrade_button]Click Here[/content_upgrade_button][/content_upgrade]',
				   'description'	=> 'Copy this shortcode and insert it on any post or page. [content_upgrade_button] is optional.'
			   ),
			   array(
				   'id'				=> 'link_template',
				   'name'			=> self::$metaPrefix .'[link_template]',
				   'type'			=> 'copy_textarea',
				   'label'			=> 'Insert a Link',
				   'default'		=> htmlspecialchars('<a class="cu-popup" href="#cu_' .  $post->ID .'">Get the bonus: ') . $post->post_title . htmlspecialchars('</a>'),
				   'description'	=> 'Copy this code and insert it in any post or page when editing in Text mode.  You must also specificy the Page or Post IDs you place it on in the "Preload on pages and posts" box in Popup settings for this Content Upgrade.'
			   )
		   )
	   );
	}

	private function prepareDripFieldGroups() {

		return array(
		   'Map Drip fields' => array(
			   array(
				   'id'				=> 'drip_first_name_field_id',
				   'name'			=> self::$metaPrefix . '[drip_first_name_field_id]',
				   'type'			=> 'text',
				   'size'			=> 45,
				   'label'			=> 'First Name field ID',
				   'default'		=> 'first_name',
				   'description'	=> 'Enter the field ID in Drip that corresponds to the user\'s first name. Defaults to "first_name"'
			   )
		   ),
		   'Automation' => array(
			   array(
				   'id'				=> 'drip_custom_event_enabled',
				   'name'			=> self::$metaPrefix . '[drip_custom_event_enabled]',
				   'type'			=> 'checkbox_with_text',
				   'label'			=> 'Drip custom event',
				   'default'		=> 0,
				   'text'			=> 'Check the box to send event to Drip',
				   'description'	=> 'Check this box to send a custom event, and enter the name of the custom event to send to Drip '
				   . 'when someone fills out the form for this Content Upgrade. Useful for triggering automation events in Drip.'
			   ),
			   array(
				   'id'				=> 'drip_custom_event_name',
				   'name'			=> self::$metaPrefix . '[drip_custom_event_name]',
				   'type'			=> 'text',
				   'size'			=> 45,
				   'label'			=> 'Custom event name',
				   'description'	=> 'Enter the custom event name to be sent to Drip.'
			   ),
			   array(
				   'id'				=> 'drip_tag_enabled',
				   'name'			=> self::$metaPrefix . '[drip_tag_enabled]',
				   'type'			=> 'checkbox_with_text',
				   'label'			=> 'Drip tagging',
				   'default'		=> 1,
				   'text'			=> 'Automatically tag subscriber in Drip',
				   'description'	=> 'Check this box to automatically apply a tag to the subscriber\'s profile in Drip'
			   ),
			   array(
				   'id'				=> 'drip_tag',
				   'name'			=> self::$metaPrefix . '[drip_tag]',
				   'type'			=> 'text',
				   'default'		=> '', //$this->options['drip_default_tags'],
				   'size'			=> 45,
				   'label'			=> 'Drip Tags',
				   'description'	=> 'Enter the comma-separated tag(s) you wish to apply to subscribers when they fill out the form for this Content Upgrade. Defaults to the title of this Content Upgrade. In addition, you can set tag(s) to be applied to all subscribers of any content upgrade in Content Upgrades > Settings > Integrations > Drip.'
			   ),
		   )
	   );
	}

	private function prepareConvertkitFieldGroups() {

		Aops::$dropdownOptions['convertkit_form_id'] = $this->options['convertkit_form_list'];
		Aops::$dropdownOptions['convertkit_tag_ids'] = $this->options['convertkit_tag_ids'];

		return array(
			'ConvertKit Tags' => array(
				array(
					'id'			=> 'convertkit_tag_enabled',
					'name'			=> self::$metaPrefix . '[convertkit_tag_enabled]',
					'type'			=> 'checkbox_with_text',
					'label'			=> 'ConvertKit tagging',
					'default'		=> 1,
					'text'			=> 'Automatically tag subscriber in ConvertKit',
					'description'	=> 'Check this box to automatically apply a tag to the subscriber\'s profile in ConvertKit'
				),
				array(
					'id'			=> 'convertkit_tag_ids',
					'name'			=> self::$metaPrefix . '[convertkit_tag_ids]',
					'type'			=> 'dropdown',
					'multiple'		=> 5,
					'label'			=> 'Custom Tags',
					'default'		=> array(),
					'description'	=> 'Select tag(s) you wish to apply to subscribers when they fill out the form for this Content Upgrade. In addition, you can set tag(s) to be applied to all subscribers of any content upgrade in Content Upgrades > Settings > Integrations > ConvertKit'
				),
				array(
					'id'			=> 'convertkit_form_id',
					'name'			=> self::$metaPrefix . '[convertkit_form_id]',
					'type'			=> 'dropdown',
					'label'			=> 'Form',
					'default'		=> $this->options['convertkit_default_formid'],
					'description'	=> 'Select a ConvertKit form to subscribe users to when they fill out the form for this Content Upgrade'
				)
			)
		);
	}

	private function prepareMailchimpFieldGroups($post) {

		// prepare values for dropdown list
		$lists = AopsMailchimpIntegration::getMailchimpLists();

		// prepare values for checkboxes array
		$groupTitles = array();
		$groups = array();
		$listGroups = array();

		foreach ($lists as $extraListId => $listName) {
			$groupTitles[$extraListId] = AopsMailchimpIntegration::getMailchimpGroupTitles($extraListId);
			$listGroups[$extraListId] = array();

			foreach ($groupTitles[$extraListId] as $groupTitleId => $groupTitle) {
				$groups[$groupTitleId] = AopsMailchimpIntegration::getMailchimpGroups($extraListId,$groupTitleId);
				$listGroups[$extraListId][] = $groupTitleId;
			}
		}


		$mailchimpFields = array(
			1 => array(
				'id'			=> 'mailchimp_list',
				'name'			=> self::$metaPrefix . '[mailchimp_list]',
				'type'			=> 'dropdown',
				'label'			=> 'List',
				'default'		=> $this->options['mailchimp_default_list'],
				'description'	=> 'Select a Mailchimp list to subscribe users to when they fill out the form for this Content Upgrade'
			)
		);


		if ($this->meta['mailchimp_extra_list_id']) {
			$extraListId = $this->meta['mailchimp_extra_list_id'];
		}
		elseif ($this->options['mailchimp_default_extra_list_id']) {
			$extraListId = $this->options['mailchimp_default_extra_list_id'];
		}
		else {
			$extraListId = 0;
		}

		// Add groups of extra List to the checkboxes array
		if ($extraListId) {

			$listName = AopsMailchimpIntegration::checkIfMailchimpListExists($extraListId);

			if ($listName) {
				$this->meta['mailchimp_extra_list_status'] = self::STATUS_OK;
				// user entered specific list ID, get groups for this list
				$lists[$extraListId] = $listName;

				$groupTitles[$extraListId] = AopsMailchimpIntegration::getMailchimpGroupTitles($extraListId);

				foreach ($groupTitles[$extraListId] as $groupTitleId => $groupTitle) {
					$groups[$groupTitleId] = AopsMailchimpIntegration::getMailchimpGroups($extraListId,$groupTitleId);
					$listGroups[$extraListId][] = $groupTitleId;
				}
			}
			else {
				$this->meta['mailchimp_extra_list_status'] = self::STATUS_FAIL;
			}
		}

		$hideMailchimpExtraListField = (!$this->meta['mailchimp_extra_list_id'])  && (!$this->options['mailchimp_default_extra_list_id']);

		if ($hideMailchimpExtraListField) {
			$footnoteFields = array(
				2 => array(
					'id'			=> 'mailchimp_footnote',
					'name'			=> self::$metaPrefix . '[mailchimp_footnote]',
					'type'			=> 'footnote',
					'size'			=> 45,
					'label'			=> 'List',
					'default'		=> 'Your list not showing up? <a href="javascript:void(0);" class="toggle_hidden_field" id="toggle_mailchimp_extra_list_id">Click here</a>'
				),
				3 => array(
					'id'			=> 'mailchimp_extra_list_id',
					'name'			=> self::$metaPrefix . '[mailchimp_extra_list_id]',
					'type'			=> 'hidden_until_toggle_text',
					'size'			=> 45,
					'label'			=> 'List ID',
					'default'		=> $this->options['mailchimp_default_extra_list_id'],
					'description'	=> 'Enter your List ID. Find your List ID in Mailchimp by going to Lists > Click the list you want to use > Settings > List name and defaults > Your "List ID" will be shown on this page.<br><br>Once a List ID is entered / saved in this field, the "Groups" should function the same way it does as if a list was selected in the dropdown.'
				)
			);
		}
		else {
			$footnoteFields = array(
				5 => array(
					'id'			=> 'mailchimp_extra_list_id',
					'name'			=> self::$metaPrefix . '[mailchimp_extra_list_id]',
					'type'			=> 'text_with_check',
					'check_type'	=> 'meta',
					'check_by'		=> $this->meta['mailchimp_extra_list_status'],
					'size'			=> 45,
					'label'			=> 'List ID',
					'default'		=> $this->options['mailchimp_default_extra_list_id'],
					'description'	=> 'Enter your List ID. Find your List ID in Mailchimp by going to Lists > Click the list you want to use > Settings > List name and defaults > Your "List ID" will be shown on this page.<br><br>Once a List ID is entered / saved in this field, the "Groups" should function the same way it does as if a list was selected in the dropdown.'
				)
			);
		}

		$mailchimpGroupFields =
		array(
			7 => array(
				'id'			=> 'mailchimp_groups',
				'name'			=> self::$metaPrefix . '[mailchimp_groups]',
				'type'			=> 'mailchimp_checkboxes_array',
				'label'			=> 'Group(s)',
				'default'		=> $this->options['mailchimp_default_groups'],
				'description'	=> 'Select the Mailchimp group(s) to subscribe users to when they fill out the form for this Content Upgrade.'
			)
		);

		$mailchimpFields = array_merge($mailchimpFields, $footnoteFields);
		$mailchimpFields = array_merge($mailchimpFields, $mailchimpGroupFields);

		// save relation between lists ang groups
		delete_post_meta( $post->ID, self::$metaPrefix . '_mailchimp_list_groups');
		add_post_meta( $post->ID, self::$metaPrefix . '_mailchimp_list_groups', $listGroups, true );


		// to use later in Aops::makeMailchimpCheckboxesArray()
		Aops::$dropdownOptions['mailchimp_list'] = array_merge( array('0' => 'Please select list') , $lists);

		Aops::$dropdownOptions['mailchimp_group_title'] = $groupTitles;
		Aops::$dropdownOptions['mailchimp_groups'] = $groups;

		return array(
			'Mailchimp Lists' => $mailchimpFields
		);

	}

	private function prepareZapierFieldGroups($post) {
		return array(
			'Zapier integration' => array(
				array(
					'id'			=> 'zapier_individual_webhook_url',
					'name'			=> self::$metaPrefix . '[zapier_individual_webhook_url]',
					'type'			=> 'text',
					'size'			=> 45,
					'label'			=> 'Webhook URL',
					'description'	=> 'Use this to create a Zapier "Zap" specific to this Content Upgrade. Get your Zapier Webhook URL by logging into Zapier and creating a Zap which uses "Content Upgrades by Audience Ops" as the Trigger.'
										. ' If you need help finding this Trigger in Zapier, contact Audience Ops support.'
				)
			)
		);
	}


	public function prepareEntriesTab() {
		$entriesTab = new AopsEntriesTab($this->cu_id);
		$entriesTab->prepare_items();
		ob_start();
		?>
			<div class="wrap"><h2 class="field-group-header">Entries</h2>
				<?php
					$entriesTab->display();
				?>
			</div>

			<p>
				<a href="edit.php?generate_aops_csv=1&cu_id=<?php echo $this->cu_id; ?>"><?php echo __("Export these entries to CSV",'aops'); ?> </a>
				|
				<a href="edit.php?post_type=aops_content_upgrade&page=aops-cu-entries"><?php echo __("View entries for all content upgrades",'aops'); ?></a>
			</p>
		<?php
		$content = ob_get_clean();

		// WP_List_Table generates none hidden inputs before the table.
		// we don't need thes as they cause "WP nonce error" when page is submitted.
		// so we are removing them:
		$content = preg_replace('/<input type="hidden" [^>]+ \/>/i', "", $content);

		return $content;
	}

		private function prepareBonusContentGroups() {

		return array(
		   'Upload bonus content' => array(
			   array(
				   'id'				=> 'bonus_content_path',
				   'name'			=> self::$metaPrefix . '[bonus_content_path]',
				   'type'			=> 'content_uploader',
				   'label'			=> 'Upload Bonus Content',
				   'default'		=> '',
				   'description'	=> 'Upload your bonus content to give to users when they opt-in for this content upgrade. This file will be linked in the <a class="cu_tab_link" href="#cu_tab_emails">email</a> you send to users.'
			   ),
			   array(
				   'id'				=> 'last_opened_tab',
				   'name'			=> self::$metaPrefix . '[last_opened_tab]',
				   'type'			=> 'hidden',
				   'label'			=> 'Last Opened tab',
				   'default'		=> '#tab_bonus',
			   )
			)
	   );
	}


	/**
	 * Callback function for 'Content upgrades' metabox
	 */
	public function displayMetabox($post) {
		$this->cu_id = $post->ID;
		$needDefaultValues = false;
		wp_nonce_field( basename( $this->pluginRoot ), 'aops_meta_box_nonce' );



		// Get meta to use later  in prepareXXXXXXFieldGroups()
		if ( $post->post_status == 'auto-draft' ) { // check if this is a new post and we nedd to use default value
			$needDefaultValues = true;
		}

		$this->meta = $this->getMeta($post->ID, $needDefaultValues);

		/*** Prepare fields ***/
		$this->bonusContentGroups = $this->prepareBonusContentGroups();
		$this->popupFieldGroups = $this->preparePopupFieldGroups();
		$this->emailFieldGroups = $this->prepareEmailFieldGroups();
		$this->insertFieldGroups = $this->prepareInsertFieldGroups($post);
		$this->miscFieldGroups = $this->prepareMiscFieldGroups($post);

		$tabs = array(
			'bonus'		=> 'Bonus content',
			'popup'		=> 'Popup',
			'emails'	=> 'Emails',
			'entries'	=> 'Entries',
			'insert'	=> 'Insert'
		);

		$drip_tab = ($this->options['drip_status'] == self::STATUS_OK) ? true : false;

		if ($drip_tab) {
			$tabs['drip'] = 'Drip';
			$this->dripFieldGroups = $this->prepareDripFieldGroups();
		}

		$convertkit_tab = ($this->options['convertkit_status'] == self::STATUS_OK) ? true : false;

		if ($convertkit_tab) {
			$tabs['convertkit'] = 'ConvertKit';
			$this->convertkitFieldGroups = $this->prepareConvertkitFieldGroups();
		}

		$mailchimp_tab = ($this->options['mailchimp_status'] == self::STATUS_OK) ? true : false;

		if ($mailchimp_tab) {
			$tabs['mailchimp'] = 'Mailchimp';
			$this->mailchimpFieldGroups = $this->prepareMailchimpFieldGroups($post);
		}

		$zapier_tab = $this->options['zapier_individual_cus'];

		if ($zapier_tab) {
			$tabs['zapier'] = 'Zapier';
			$this->zapierFieldGroups = $this->prepareZapierFieldGroups($post);
		}


		$tabs['misc'] = 'Misc';

		?>
		<div class="cu-metabox-wrap">

			<div id="cu_tab_container" class="tab-container">
				<ul class='etabs'>
					<?php foreach ($tabs as $tabId => $tabName) : ?>
						<li class='ao-tab' id="tab_<?php echo $tabId; ?>"><a href="#cu_tab_<?php echo $tabId; ?>"><?php echo $tabName; ?></a></li>
					<?php endforeach; ?>
				</ul>
				<div class='panel-container'>
					<div id="cu_tab_bonus">
						<?php echo $this->makeTabFields($this->bonusContentGroups, $post); ?>
					</div>
					<div id="cu_tab_popup">
						<?php echo $this->makeTabFields($this->popupFieldGroups, $post); ?>
					</div>
					<div id="cu_tab_emails">
						<?php echo $this->makeTabFields($this->emailFieldGroups, $post); ?>
					</div>
					<div id="cu_tab_entries">
						<?php echo $this->prepareEntriesTab(); ?>
					</div>
					<div id="cu_tab_insert">
						<?php echo $this->makeTabFields($this->insertFieldGroups, $post); ?>
					</div>
					<?php if ($drip_tab) :?>
						<div id="cu_tab_drip">
							<?php echo $this->makeTabFields($this->dripFieldGroups, $post); ?>
						</div>
					<?php endif; ?>
					<?php if ($convertkit_tab) :?>
						<div id="cu_tab_convertkit">
							<?php echo $this->makeTabFields($this->convertkitFieldGroups, $post); ?>
						</div>
					<?php endif; ?>
					<?php if ($mailchimp_tab) :?>
						<div id="cu_tab_mailchimp">
							<?php echo $this->makeTabFields($this->mailchimpFieldGroups, $post); ?>
						</div>
					<?php endif; ?>
					<?php if ($zapier_tab) :?>
						<div id="cu_tab_zapier">
							<?php echo $this->makeTabFields($this->zapierFieldGroups, $post); ?>
						</div>
					<?php endif; ?>
					<div id="cu_tab_misc">
						<?php echo $this->makeTabFields($this->miscFieldGroups, $post); ?>
					</div>
				</div>	<!-- / .panel-container -->
			</div> <!-- / #cu_tab_container -->

		</div><!-- /.cu-metabox-wrap -->

		<!-- notify about copy  -->
		<div id="flash-message"></div>
		<?php

	}

	private function makeTabFields($fieldGroups, $post) {
		$this->meta = $this->getMeta($post->ID);

		foreach ($fieldGroups as $fieldGroupName => $fields) { ?>
			<h2 class="field-group-header"><?php echo $fieldGroupName; ?></h2>
			<table class="form-table">
			<?php foreach ($fields as $field) {

				if (isset($this->meta[$field['id']])) {
					$value = $this->meta[$field['id']];
				}
				else {
					$value = false;
				}

				if ( $post->post_status == 'auto-draft' ) { // check if this is a new post and we nedd to use default value
					if (!$value) {
						$value = isset($field['default']) ? $field['default'] : '';
					}
				}

				echo $this->makeField($field, $value);
			}
			?>
			</table>
		<?php }
	}

	/**
	 * Gets list of all CU entries.
	 * Used by makeUpgradesListForm()
	 * @global type $wpdb
	 * @return type
	 */
	public function getContentUpgradesList() {
		global $wpdb;
		$contentUpgrades = array();

		$sql = $wpdb->prepare("SELECT ID, post_title FROM $wpdb->posts	WHERE post_type = '%s' and post_status = 'publish'", self::$postTypeName);
		$cuEntries = $wpdb->get_results($sql, ARRAY_A );

		foreach($cuEntries as $cuEntry) {
			$contentUpgrades[$cuEntry['ID']] = $cuEntry['post_title'];
		}
		return $contentUpgrades;
	}

	/**
	 * Creates "Insert CU" button on Edit Post screen
	 */
	private function makeUpgradesListForm() {
		$contentUpgrades = $this->getContentUpgradesList();

		$options = "<option value='0' >Please select...</option>";

		if (count($contentUpgrades)) {
			foreach ($contentUpgrades as $cuId => $cuTitle) {
				$options .= "<option value='cu_$cuId'>[$cuId] $cuTitle</option>";
			}

			$select = '<select id="aops-content-upgrades-select">';
			$select .= $options;
			$select .= '</select>';
		}
		else {
			$link = admin_url('post-new.php?post_type=aops_content_upgrade');
			$select = '<p style="color:red">No Content Upgrades found!</p>'
					. '<p>Maybe none created yet?</p>'
					. '<p><a href="' . $link . '" target="_blank">Create Content Upgrade</a></p>'
					. '<small>Refresh this page to see created CU in this popup</small>';
		}


		$html = $select;

		$html .= '<div id="aops-content-upgrades-copybox" style="display:none">';
		$html .= '<h3>To insert opt-in into post:</h3>';
		$html .= '<div class="aops_copy_textarea"><span onclick="selectText(\'aops-copybox-shortcode\')" id="aops-copybox-shortcode"></span></div>';
		$html .= '<a href="javascript:void(0)" class="button button-primary button-large" id="aops-copy-shortcode" data-clipboard-text="">Copy</a>';
		$html .= '<a href="javascript:void(0)" class="button button-primary button-large" id="aops-insert-shortcode" data-insert-text="">Insert</a>';
		$html .= '<h3>To insert link into post:</h3>';
		$html .= '<div class="aops_copy_textarea"><span onclick="selectText(\'aops-copybox-link\')" id="aops-copybox-link"></span></div>';
		$html .= '<a href="javascript:void(0)" class="button button-primary button-large" id="aops-copy-link" data-clipboard-text="">Copy</a>';
		$html .= '<a href="javascript:void(0)" class="button button-primary button-large" id="aops-insert-link" data-insert-text="">Insert</a>';
		$html .= '</div>';

		return $html;
	}
}
?>
